/*
 * Decompiled with CFR 0.152.
 */
package com.chrisgli.gemsnjewels.items;

import com.chrisgli.gemsnjewels.config.GemsNJewelsConfig;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.state.BlockState;

public class GemSetHoe
extends HoeItem {
    private final float baseAttackSpeed;
    private final int baseAttackDamage;

    public GemSetHoe(Tier tier, int attackDamageIn, float attackSpeedIn, Item.Properties builder) {
        super(tier, attackDamageIn, attackSpeedIn, builder);
        this.baseAttackSpeed = attackSpeedIn;
        this.baseAttackDamage = attackDamageIn;
    }

    public int getBaseAttackDamage() {
        return this.baseAttackDamage;
    }

    public float getBaseAttackSpeed() {
        return this.baseAttackSpeed;
    }

    public int getLevelProgress(ItemStack stack) {
        double blockCount = 0.0;
        double cropCount = 0.0;
        int blocksPerLevel = (Integer)GemsNJewelsConfig.COMMON.hoeHoesPerLevel.get();
        int cropsPerLevel = (Integer)GemsNJewelsConfig.COMMON.hoeCropsPerLevel.get();
        if (stack.m_41782_()) {
            CompoundTag nbt = stack.m_41783_();
            if (nbt.m_128441_("Blocks") && blocksPerLevel > 0) {
                blockCount = (double)(nbt.m_128451_("Blocks") % blocksPerLevel) * (10.0 / (double)blocksPerLevel);
            }
            if (nbt.m_128441_("Crops") && cropsPerLevel > 0) {
                cropCount = (double)(nbt.m_128451_("Crops") % cropsPerLevel) * (10.0 / (double)cropsPerLevel);
            }
        }
        return (int)Math.floor(blockCount + cropCount);
    }

    public int getCurrentLevel(ItemStack stack) {
        double blockProgress = 0.0;
        double cropProgress = 0.0;
        int blocksPerLevel = (Integer)GemsNJewelsConfig.COMMON.hoeHoesPerLevel.get();
        int cropsPerLevel = (Integer)GemsNJewelsConfig.COMMON.hoeCropsPerLevel.get();
        if (stack.m_41782_()) {
            CompoundTag nbt = stack.m_41783_();
            if (nbt.m_128441_("Blocks") && blocksPerLevel > 0) {
                blockProgress = (double)nbt.m_128451_("Blocks") / (double)blocksPerLevel;
            }
            if (nbt.m_128441_("Crops") && cropsPerLevel > 0) {
                cropProgress = (double)nbt.m_128451_("Crops") / (double)cropsPerLevel;
            }
        }
        return (int)(blockProgress + cropProgress);
    }

    public InteractionResult m_6225_(UseOnContext context) {
        InteractionResult pass = super.m_6225_(context);
        if (pass.equals((Object)InteractionResult.SUCCESS) || pass.equals((Object)InteractionResult.CONSUME)) {
            ItemStack stack = context.m_43722_();
            CompoundTag nbt = stack.m_41782_() ? stack.m_41783_() : new CompoundTag();
            if (nbt.m_128441_("Blocks")) {
                nbt.m_128405_("Blocks", nbt.m_128451_("Blocks") + 1);
            } else {
                nbt.m_128405_("Blocks", 1);
            }
            stack.m_41751_(nbt);
            if (((Boolean)GemsNJewelsConfig.COMMON.toolLevelingEnabled.get()).booleanValue()) {
                int level = this.getCurrentLevel(stack);
                Level world = context.m_43725_();
                if (level >= 7 && !world.m_5776_()) {
                    Player playerentity = context.m_43723_();
                    int randomChance = world.f_46441_.nextInt(2);
                    if (playerentity != null && randomChance == 1) {
                        context.m_43722_().m_41622_(-1, (LivingEntity)playerentity, p_220041_1_ -> p_220041_1_.m_21190_(context.m_43724_()));
                    }
                }
                if (level >= 3 && !world.m_5776_()) {
                    int j;
                    for (int i = world.f_46441_.nextInt(2) + world.f_46441_.nextInt(2); i > 0; i -= j) {
                        j = ExperienceOrb.m_20782_((int)i);
                        world.m_7967_((Entity)new ExperienceOrb(world, (double)context.m_8083_().m_123341_(), (double)(context.m_8083_().m_123342_() + 1), (double)context.m_8083_().m_123343_(), j));
                    }
                }
            }
        }
        return pass;
    }

    public boolean m_6813_(ItemStack stack, Level worldIn, BlockState state, BlockPos pos, LivingEntity entityLiving) {
        CropBlock crop;
        if (state.m_60734_() instanceof CropBlock && (crop = (CropBlock)state.m_60734_()).m_52307_(state)) {
            CompoundTag nbt = stack.m_41782_() ? stack.m_41783_() : new CompoundTag();
            if (nbt.m_128441_("Crops")) {
                nbt.m_128405_("Crops", nbt.m_128451_("Crops") + 1);
            } else {
                nbt.m_128405_("Crops", 1);
            }
            stack.m_41751_(nbt);
            return true;
        }
        return super.m_6813_(stack, worldIn, state, pos, entityLiving);
    }

    public boolean m_7579_(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        int level = this.getCurrentLevel(stack);
        if (((Boolean)GemsNJewelsConfig.COMMON.toolLevelingEnabled.get()).booleanValue()) {
            int randomChance = attacker.f_19853_.f_46441_.nextInt(2);
            if (level >= 7 && randomChance == 1) {
                return true;
            }
        }
        return super.m_7579_(stack, target, attacker);
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot equipmentSlot, ItemStack stack) {
        HashMultimap multimap = HashMultimap.create();
        if (equipmentSlot != EquipmentSlot.MAINHAND || !((Boolean)GemsNJewelsConfig.COMMON.toolLevelingEnabled.get()).booleanValue()) {
            return super.getAttributeModifiers(equipmentSlot, stack);
        }
        float attackSpeedBonus = -1.0f * this.getBaseAttackSpeed();
        int lvl = this.getCurrentLevel(stack);
        attackSpeedBonus = attackSpeedBonus * (float)lvl / 20.0f;
        attackSpeedBonus = Math.min(1024.0f, attackSpeedBonus);
        multimap.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(f_41374_, "Weapon modifier", 0.0, AttributeModifier.Operation.ADDITION));
        multimap.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(f_41375_, "Weapon modifier", (double)this.getBaseAttackSpeed() + (double)attackSpeedBonus, AttributeModifier.Operation.ADDITION));
        return multimap;
    }

    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        super.m_7373_(stack, worldIn, tooltip, flagIn);
        if (stack.m_41782_() && (stack.m_41783_().m_128441_("Blocks") || stack.m_41783_().m_128441_("Crops"))) {
            int i;
            int blockCount = stack.m_41783_().m_128451_("Blocks");
            String blocks = "\u00a7e" + Integer.toString(blockCount);
            int cropCount = stack.m_41783_().m_128451_("Crops");
            String crops = "\u00a7e" + Integer.toString(cropCount);
            if (blockCount > 0) {
                TextComponent hoed = new TextComponent("Blocks Hoed: " + blocks);
                tooltip.add((Component)hoed);
            }
            if (cropCount > 0) {
                TextComponent farmed = new TextComponent("Crops Farmed: " + crops);
                tooltip.add((Component)farmed);
            }
            int lvlProgress = this.getLevelProgress(stack);
            int lvl = this.getCurrentLevel(stack);
            String level = "Lvl: " + lvl;
            level = lvl < 5 ? level + " \u00a77Novice" : (lvl < 10 ? level + " \u00a7aAdept" : (lvl < 20 ? level + " \u00a7bHeroic" : (lvl < 30 ? level + " \u00a7dMaster" : (lvl < 100 ? level + " \u00a7eLegendary" : level + " \u00a76Mythic"))));
            Object progression = "|\u00a7a";
            for (i = 0; i < lvlProgress; ++i) {
                progression = (String)progression + "=";
            }
            progression = (String)progression + "\u00a77";
            for (i = lvlProgress; i < 10; ++i) {
                progression = (String)progression + "-";
            }
            progression = (String)progression + "\u00a7f|";
            TextComponent levelText = new TextComponent(level);
            TextComponent progText = new TextComponent((String)progression);
            tooltip.add((Component)levelText);
            tooltip.add((Component)progText);
            tooltip.add((Component)new TextComponent("\u00a75-Gains bonus swing speed per level"));
            if (lvl >= 3) {
                tooltip.add((Component)new TextComponent("\u00a75-Hoeing blocks grants experience"));
            }
            if (lvl >= 7) {
                tooltip.add((Component)new TextComponent("\u00a75-Resists tool damage"));
            }
        } else if (((Boolean)GemsNJewelsConfig.COMMON.toolLevelingEnabled.get()).booleanValue()) {
            tooltip.add((Component)new TextComponent("\u00a77Gains perks from use"));
        }
    }
}

